/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypeDeclarationPrologConverter
extends NodeConverter<TypeDeclaration> {
    private static final String CLASS_KEY = "class_declaration";
    private static final String INTERFACE_KEY = "interface_declaration";
    private static final String[] CLASS_KEYS;
    private static final String[] INTERFACE_KEYS;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "parent";
        stringArray[3] = "parameters_types";
        stringArray[4] = "modifiers";
        stringArray[5] = "super_type";
        stringArray[6] = "implements";
        stringArray[7] = "fields";
        stringArray[8] = "methods";
        stringArray[9] = "declarations";
        stringArray[10] = "compilation_unit";
        CLASS_KEYS = stringArray;
        String[] stringArray2 = new String[10];
        stringArray2[1] = "parent";
        stringArray2[3] = "parameters_types";
        stringArray2[4] = "modifiers";
        stringArray2[5] = "super_type";
        stringArray2[6] = "fields";
        stringArray2[7] = "methods";
        stringArray2[8] = "declarations";
        stringArray2[9] = "compilation_unit";
        INTERFACE_KEYS = stringArray2;
    }

    public TypeDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(TypeDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String name = this.quote(node.getName().getIdentifier());
        String fact = node.isInterface() ? INTERFACE_KEY : CLASS_KEY;
        String[] keys = node.isInterface() ? INTERFACE_KEYS : CLASS_KEYS;
        Vector<ASTNode> parameters_types_nodes = new Vector<ASTNode>();
        parameters_types_nodes.addAll(node.typeParameters());
        for (ASTNode parameter : parameters_types_nodes) {
            this.converter_factory.getConverter(parameter).convert(parameter);
        }
        String parameters_types = this.generateList(parameters_types_nodes);
        String super_type = null;
        if (node.getSuperclassType() != null) {
            this.converter_factory.getConverter((ASTNode)node.getSuperclassType()).convert(node.getSuperclassType());
            super_type = this.mapper.getNodeID((ASTNode)node.getSuperclassType());
        }
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        Vector<ASTNode> implements_nodes = new Vector<ASTNode>();
        implements_nodes.addAll(node.superInterfaceTypes());
        for (ASTNode implement : implements_nodes) {
            this.converter_factory.getConverter(implement).convert(implement);
        }
        String implements_ids = this.generateList(implements_nodes);
        Vector<ASTNode> declarations_nodes = new Vector<ASTNode>();
        declarations_nodes.addAll(node.bodyDeclarations());
        for (ASTNode declaration : declarations_nodes) {
            this.converter_factory.getConverter(declaration).convert(declaration);
        }
        String declarations = this.generateList(declarations_nodes);
        Vector<ASTNode> fields_nodes = new Vector<ASTNode>();
        fields_nodes.addAll(Arrays.asList(node.getFields()));
        String fields = this.generateList(fields_nodes);
        Vector<ASTNode> methods_nodes = new Vector<ASTNode>();
        methods_nodes.addAll(Arrays.asList(node.getMethods()));
        String methods = this.generateList(methods_nodes);
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = null;
        args = node.isInterface() ? new String[]{id, parent, name, parameters_types, modifiers, super_type, fields, methods, declarations, unit} : new String[]{id, parent, name, parameters_types, modifiers, super_type, implements_ids, fields, methods, declarations, unit};
        this.code.addFact(fact, this.generateArgs(keys, args));
    }

    @Override
    public void bind(TypeDeclaration node) {
        this.mapper.setBindingID((IBinding)node.resolveBinding(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        Vector parameters_types_nodes = new Vector();
        parameters_types_nodes.addAll(node.typeParameters());
        for (ASTNode parameter : parameters_types_nodes) {
            this.converter_factory.getConverter(parameter).bind(parameter);
        }
        if (node.getSuperclassType() != null) {
            this.converter_factory.getConverter((ASTNode)node.getSuperclassType()).bind(node.getSuperclassType());
        }
        Vector implements_nodes = new Vector();
        implements_nodes.addAll(node.superInterfaceTypes());
        for (ASTNode implement : implements_nodes) {
            this.converter_factory.getConverter(implement).bind(implement);
        }
        Vector declarations_nodes = new Vector();
        declarations_nodes.addAll(node.bodyDeclarations());
        for (ASTNode declaration : declarations_nodes) {
            this.converter_factory.getConverter(declaration).bind(declaration);
        }
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        for (ASTNode modifier : modifiers_nodes) {
            this.converter_factory.getConverter(modifier).bind(modifier);
        }
    }

    @Override
    public String getName(TypeDeclaration node) {
        String type = "class";
        if (node.isInterface()) {
            type = "interface";
        }
        return String.valueOf(type) + " " + node.getName().toString();
    }
}

