/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;

public class AssignmentPrologConverter
extends NodeConverter<Assignment> {
    private static final String KEY = "assignment";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[2] = "operator";
        stringArray[3] = "left_operand";
        stringArray[4] = "right_operand";
        stringArray[5] = "body_declaration";
        stringArray[6] = "type_declaration";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public AssignmentPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(Assignment node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String operator = this.quote(this.operator(node.getOperator().toString()));
        this.converter_factory.getConverter((ASTNode)node.getLeftHandSide()).convert(node.getLeftHandSide());
        String left_operand = this.mapper.getNodeID((ASTNode)node.getLeftHandSide());
        this.converter_factory.getConverter((ASTNode)node.getRightHandSide()).convert(node.getRightHandSide());
        String right_operand = this.mapper.getNodeID((ASTNode)node.getRightHandSide());
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, operator, left_operand, right_operand, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(Assignment node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getLeftHandSide()).bind(node.getLeftHandSide());
        this.converter_factory.getConverter((ASTNode)node.getRightHandSide()).bind(node.getRightHandSide());
    }
}

