/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IfStatement;

public class IfStatementPrologConverter
extends NodeConverter<IfStatement> {
    private static final String KEY = "if_statement";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[2] = "condition";
        stringArray[3] = "then";
        stringArray[4] = "else";
        stringArray[5] = "body_declaration";
        stringArray[6] = "type_declaration";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public IfStatementPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(IfStatement node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        this.converter_factory.getConverter((ASTNode)node.getExpression()).convert(node.getExpression());
        String condition = this.mapper.getNodeID((ASTNode)node.getExpression());
        this.converter_factory.getConverter((ASTNode)node.getThenStatement()).convert(node.getThenStatement());
        String then_block = this.mapper.getNodeID((ASTNode)node.getThenStatement());
        this.converter_factory.getConverter((ASTNode)node.getElseStatement()).convert(node.getElseStatement());
        String else_block = this.mapper.getNodeID((ASTNode)node.getElseStatement());
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, condition, then_block, else_block, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(IfStatement node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getExpression()).bind(node.getExpression());
        this.converter_factory.getConverter((ASTNode)node.getThenStatement()).bind(node.getThenStatement());
        this.converter_factory.getConverter((ASTNode)node.getElseStatement()).bind(node.getElseStatement());
    }

    @Override
    public String getName(IfStatement node) {
        return "if(" + node.getExpression().toString() + ")";
    }
}

